#version 330
#extension GL_EXT_gpu_shader4 : enable
//Listening to the mindMod01.fsh  by rmmcal 
//https://www.shadertoy.com/view/Ws3yzS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////
////         ....  Listening to the mind...              ////
/////////////////////////////////////////////////////////////
// Brasil/Amazonas/Manaus
// Created by Rodrigo Cal (twitter: @rmmcal)🧙🧞
// - Started: 2020/10 - Published: 2020/10
// - https://www.shadertoy.com/view/Ws3yzS
/////////////////////////////////////////////////////////////
// -----------------------------------------------------------
//
//  Listening to the mind => 🎧🧠
//  
//	Pass: Mente&Ouvinte 
//  
//      ... @rmmcal 2020/20 
//
//  Inspiration/Wiki: 
// 	=> https://en.wikipedia.org/wiki/Gyroid
//  
// -----------------------------------------------------------
/////////////////////////////////////////////////////////////
//

float dist(vec3 p){
    p *= 1.;
    float d = 100.;

    float a = p.z*fract(iTime*.1)*0.01;
    d = 1.4-abs(sin(p.x)*cos(p.y)+sin(p.y)*cos(p.z)+sin(p.z)*cos(p.x))-cos(p.z*2.-fract(iTime)*3.1415926*2.)/120.;

    vec3 tv = p*21.+iTime*3.;
    vec3 ctv = cos(tv);
    d += .02*( smoothstep(-1.0,1.5, .5 - abs(ctv.x + ctv.y + ctv.z)) ) *abs(fract(iTime*1.)*2.-1.)*2.;

	d -=  texture2D(iChannel3,vec2(sqrt(abs(p.z*.01)),0.)).r*.1;
  
    return d;
}

vec3 normal3d(vec3 p)
{
  vec3 eps = vec3(.001,0.0,0.0);
  vec3 nor;
  float ref;
  nor.x = dist(p+eps.xyy) - dist(p-eps.xyy);
  nor.y = dist(p+eps.yxy) - dist(p-eps.yxy);
  nor.z = dist(p+eps.yyx) - dist(p-eps.yyx);
  return -normalize(nor);
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float time2 = (iTime*.5);
    vec2 aspectRatio = vec2(1., iResolution.y/iResolution.x);
	vec2 uv = gl_FragCoord.xy/iResolution.xy; 
    vec2 p = (uv-.5)*aspectRatio;

    vec3 cpos = vec3(0.0,0.0,-20.0);
    vec3 cdir = vec3(0.0,0.0,  0.0);
    
    cpos += vec3(iTime/3.,0.0,(cos(iTime*.08)*11.)) * clamp(pow(iTime*.2,8.),0.,1.);
    
    vec3 ray = vec3(sin(p.xy)*1.,.5);
   
    vec3 g;
    for (int i = 0; i < 250; i++)
    {
        float d = dist(cpos);
        cpos += ray*d;
        if (d < 0.01) break;
        if (d > 128.) break;
        g += vec3(1.,-0.3,.1)/(d*3000.);
    }
    vec3 n  = normal3d(cpos);
    vec3 an  = abs(n);
    
    vec3 col = vec3(1.,0.7,0.)*vec3((an.x+an.y+an.z)*.4);
    
    col +=  vec3(4.,0.,10.)*vec3( smoothstep(-.2,01.5, .4-abs(cpos.z-fract(iTime*0.1)*20.+20.)) );
   
    vec3 tv = cpos*21.+iTime*3.;
    vec3 ctv = cos(tv);
    
	col +=  vec3(0.,1.,1.)*vec3( smoothstep(-.0,5.5, 1.6-abs(cos(tv.y*.1)+cos(tv.x*.1)+cos(tv.z*.1)  )) );
    col +=  vec3(0.4,.5,0.)*vec3( smoothstep(-3.0,2.5, .5 - abs(ctv.x + ctv.y + ctv.z)) );
    col +=  vec3(1.,0.,01.)*vec3( smoothstep(-.0,1.5, .5 - abs(ctv.x + ctv.y + ctv.z)) );
    col *= n.z*.3+.7;
    col = mix( vec3(1.),col,smoothstep(-50.,40., -cpos.z));
 
    vec3 neon = g*abs(fract(iTime*.2)*2.-1.)*.5;
	col += neon;
    col = mix( col, vec3(1.5)+ g*2., length(p)*1.2-.1);
    
    col = mix(vec3(0.5*length(col)), col , cos(iTime*.5)*clamp(0.,1.,iTime*.01));
    col = mix(col,vec3(0.) ,   smoothstep(0.,1.,length(p)+1.-1.*clamp(0.,1.,iTime*.5)));
    
    gl_FragColor = vec4(col,1.0);
}